<!DOCTYPE html>
<html>

<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="images/fav.png" rel="icon" />

    <title>Sesp</title>
    <link rel="stylesheet" href="css/icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="css/style.css">

    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
</head>

<body>
    <?php include 'include.php';?>
    <section class="inner-banner d-flex align-items-center">
        <div class="container-fluid">
            <h1>Why SESP</h1>
        </div>
    </section>

    <section class="content-area-space1">
        <div class="container-fluid">
            <div class="row d-flex align-items-center">
                <div class="col-lg-6 image-pad">
                    <div class="image-after2">
                        <img src="images/lifelong.jpg" class="img-fluid">
                    </div>
                </div>
                <div class="col-lg-6 why-sep-sec">
                    <h2>Lifelong <span>Learning</span> Skills</h2>
                    <p>Inherent in SESP’s technical delivery is a constant focus on the essential lifelong-learning skills needed in today’s modern working environment. SESP strives to instill positive work ethics, attitudes and behavior in our trainees,
                        attributes built on respect for others, their technical disciplines and the company. Ensuring a strong understanding and appreciation for workplace safety among the trainees is paramount in SESP. Developing discipline, self-learning
                        and self-monitoring techniques among the trainees is also important within SESP. Implementing a sound health and safety regimen is a daily classroom and workshop requisite from Day 1 of the program, thereby ensuring the trainees’
                        full awareness of best safety practices, hazards identification and proper use of Personal Protection Equipment.</p>
                </div>
            </div>
        </div>
    </section>

    <section class="content-area-space">
        <div class="why-bg-sec">
            <div class="container-fluid">
                <div class="row d-flex align-items-center">
                    <div class="col-lg-6 why-sep-sec">
                        <h2>External and Community <span>Training</span></h2>
                        <p>SESP is aware of its commitment to the wider society by implementing its Outreach Program and bringing English language training to young people in local communities. SESP is also fully engaged in providing English-for-specific
                            purposes training to industrial based clients in order to assist them in achieving their Saudi national strategy for better trained and highly skilled employees.</p>
                    </div>
                    <div class="col-lg-6 image-pad2">
                        <div class="image-after">
                            <img src="images/community.jpg" class="img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>




    <section class="content-area-space1">
        <div class="container-fluid">
            <div class="row d-flex align-items-center">
                <div class="col-lg-6 image-pad">
                    <div class="image-after2">
                        <img src="images/training.jpg" class="img-fluid">
                    </div>
                </div>
                <div class="col-lg-6 why-sep-sec">
                    <h2>International <span>Training</span> Partners</h2>
                    <p>SESP understands that delivery of a quality training and development product for SEC, and other local industries and companies, involves the expertise of many entities. SESP been able to pass on the benefits of teaming up with internationally
                        recognized training providers including AMIDEAST, GP Strategies, American Welding Society, and University of Cambridge’s Delta Program implemented through international House- London, ACT/NEBOSH’s National Diploma Program and Manitoba
                        Hydro International.</p>
                    <p>SESP is committed to delivering the highest quality training through associations with these and other international partners by recruiting highly skilled trainers with extensive industrial plant experience in all aspects of the power
                        utility industry. Utilizing the skill set of both SESP’s own team of subject matter experts complemented by international partners has enabled us to guarantee that the learning and training experiences of our trainees are current,
                        relevant and appropriate to their disciplines.</p>
                    <p>SESP has also established itself as a center for delivering externally accredited health and safety and welding technology courses among others. The external awarding bodies partnering with SESP (SQA accreditation body) wile enable
                        SESP to provide SEC and other industrial-based clients with the suitably and better qualified graduate trainees they require.</p>
                </div>
            </div>
        </div>
    </section>


    <section class="content-area-space">
        <div class="why-bg-sec">
            <div class="container-fluid">
                <div class="row d-flex align-items-center">
                    <div class="col-lg-6 why-sep-sec">
                        <h2>Health & <span>Safety</span></span>
                        </h2>
                        <p>The importance of industrial health and safety workplace in preparing our trainees for their future work and life cannot be over-stated. This is a critical part of SESP’s mission.</p>
                        <p>Making our trainees aware of risks and teaching them safe work practices are core to SESP’s daily work. SESP take its responsibilities in prompting a culture of health and safety extremely seriously by working closely with its
                            onsite subject matter experts and international partners such as the British Safety Council and ACT implementing internationally recognized safety programs such as BSC’S Safety Management System and SEC’s “5Star Safety Program”
                            across all SESP’s training sites ensures that our trainees acquire their own health and safety qualifications during their tenure with SESP.</p>

                    </div>
                    <div class="col-lg-6 image-pad2">
                        <div class="image-after">
                            <img src="images/healthy.jpg" class="img-fluid">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="content-area-space1">
        <div class="container-fluid ">
            <div class="row d-flex align-items-center">
                <div class="col-lg-6 image-pad">
                    <div class="image-after2">
                        <img src="images/quality.jpg" class="img-fluid">
                    </div>
                </div>
                <div class="col-lg-6 why-sep-sec">
                    <h2>Quality <span>Assurance</span></h2>
                    <p>Continuous quality improvement is embedded in SESP’S culture. Our standards are regularly scrutinised ensuring the highest quality against our required outcomes in all of our training initiatives. Our in-house quality assurance teams
                        complete internal verification of course delivery to ensure training standards are at their highest level with a formal system for improvements in place and actioned as necessary.</p>
                    <p>SESP’s Quality Management System governs the processes implemented throughout the organization and in compliance with the standards of our international partners.</p>
                </div>
            </div>
        </div>
    </section>


    <div class="container-fluid">
        <div class="row d-flex justify-content-center" style="margin-top:20px;">
            <div class="pdf-bg">
                <section>
                    <div class="pdf-view-bg d-flex align-items-center justify-content-between flex-column flex-md-row">
                        <h3>Our prospectus: SESP – Prospectus <span>2019 – 2020</span></h3>
                        <a href="images/prospectus.pdf" target="_blank">
                            <div class="d-flex align-items-center">
                                <i class="fa fa-file-pdf" aria-hidden="true"></i>
                                <h2>View PDF</h2>
                            </div>
                        </a>
                    </div>
                </section>
            </div>
        </div>
    </div>


    </div>
    </section>

    <div class="sec-pad">
        <?php include("footer.php")?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

</body>

</html>